/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListerTools {
    private static List<String> list_Dirs_Files_Hidden_Paths(String dirname, boolean listDirs, boolean listFiles, boolean listHidden, boolean listPaths) {
        if (dirname == null) {
            throw new NullPointerException("Name of directory must not be null");
        }
        if (dirname.isEmpty()) {
            throw new IllegalArgumentException("Name of directory must not be empty");
        }
        if (!new File(dirname).exists() || !new File(dirname).isDirectory()) {
            throw new IllegalArgumentException("Name '" + dirname + "' must be an existing directory");
        }
        if (!listDirs && !listFiles) {
            throw new IllegalArgumentException("At least one of 'listDirs' or 'listFiles' must be true");
        }
        File dir = new File(dirname);
        File[] filesArray = dir.listFiles();
        ArrayList<String> filenames = new ArrayList<String>();
        if (filesArray == null || filesArray.length == 0) {
            return filenames;
        }
        List<File> files = Arrays.asList(filesArray);
        files.stream().filter(file -> listHidden || !file.isHidden()).forEach(file -> {
            if (listDirs && file.isDirectory() || listFiles && file.isFile()) {
                if (listPaths) {
                    filenames.add(file.getAbsolutePath());
                } else {
                    filenames.add(file.getName());
                }
            }
        });
        Collections.sort(filenames);
        return filenames;
    }

    public static List<String> list_Dirs_Files_Paths(String dirname, boolean listDirs, boolean listFiles, boolean listPaths) {
        return ListerTools.list_Dirs_Files_Hidden_Paths(dirname, listDirs, listFiles, true, listPaths);
    }

    public static List<String> list_ExistingFilesRecursive(String dirname) {
        List<String> allFiles = ListerTools.list_Dirs_Files_Paths(dirname, false, true, true);
        ArrayList<String> files = new ArrayList<String>();
        File file = null;
        for (String filename : allFiles) {
            file = new File(filename);
            if (!file.exists() || file.length() <= 0L) continue;
            files.add(filename);
        }
        Collections.sort(files);
        List<String> dirs = ListerTools.list_Dirs_Files_Paths(dirname, true, false, true);
        dirs.forEach(dir -> {
            boolean bl = files.addAll(ListerTools.list_ExistingFilesRecursive(dir));
        });
        return files;
    }

    public static List<String> fileListToStringList(List<File> Files) {
        ArrayList<String> list = new ArrayList<String>();
        Files.forEach(File2 -> {
            boolean bl = list.add(File2.toString());
        });
        return list;
    }

    public static List<File> stringListToFileList(List<String> strings) {
        ArrayList<File> list = new ArrayList<File>();
        strings.forEach(string -> {
            boolean bl = list.add(new File((String)string));
        });
        return list;
    }
}

